﻿using System.Data;
using Microsoft.Data.SqlClient;
using NT.AltText.Models;
using NT.AltText.Repository.Database;
using NT.AltText.Repository.Interfaces;
using NT.AltText.Repository.Models;

namespace NT.AltText.Repository
{
    public class CatsheetImageProcessingRepository : ICatsheetImageProcessingRepository
    {
        private readonly string connectionString = AltTextDbConnection.GetConnection();

        public async Task<int> AddCatsheetImageProcessing(CatsheetImageProcessing catsheet)
        {
            using var conn = new SqlConnection(connectionString);
            using var cmd = new SqlCommand(SpNames.AddCatsheetImageProcessing, conn)
            {
                CommandType = CommandType.StoredProcedure
            };


            cmd.Parameters.AddWithValue("@JobId", (object?)catsheet.JobId ?? DBNull.Value);
            cmd.Parameters.AddWithValue("@ChapterNumber", (object?)catsheet.ChapterNumber ?? DBNull.Value);
            cmd.Parameters.AddWithValue("@Status", (object?)catsheet.Status ?? DBNull.Value);

            var outputIdParam = new SqlParameter("@NewId", SqlDbType.Int)
            {
                Direction = ParameterDirection.Output
            };
            cmd.Parameters.Add(outputIdParam);

            await conn.OpenAsync();
            await cmd.ExecuteNonQueryAsync();

            return outputIdParam.Value == DBNull.Value ? 0 : (int)outputIdParam.Value;
        }
    }
}
