﻿using Microsoft.AspNetCore.Mvc;
using NT.AltText.Controllers;
using NT.AltText.Models;
using NT.AltText.Repository.Interfaces;

namespace NT.AltText.Controllers
{
    [Route("api/[controller]")]
    [ApiController]
    public class UserJobController : ControllerBase
    {
        private readonly IUserJobRepository _repository;

        public UserJobController(IUserJobRepository repository)
        {
            _repository = repository;
        }

        [HttpGet]
        public async Task<IActionResult> GetAll()
        {
            var jobs = await _repository.GetAllJobsAsync();
            return Ok(jobs);
        }

        [HttpGet("{id}")]
        public async Task<IActionResult> GetById(int id)
        {
            var job = await _repository.GetJobByIdAsync(id);
            if (job == null) return NotFound();
            return Ok(job);
        }

        [HttpPost]
        public async Task<IActionResult> Create(UserJobDetails  userJobDetails)
        {
            var created = await _repository.AddAssignedJobAsync(userJobDetails);
            return Ok(created);
        }

        [HttpPut]
        public async Task<IActionResult> UpdateStatus(UpdateStatusForJob updateStatusForJob)
        {
            var created = await _repository.UpdateStatusByJobIdAndAssignedTo(updateStatusForJob);
            return Ok(created);
        }


    }
}
