﻿using Microsoft.AspNetCore.Mvc;
using NT.AltText.Models;
using NT.AltText.Repository.Interfaces;

namespace NT.AltText.API.Controllers
{
    [ApiController]
    [Route("api/[controller]")]
    public class ReviewerQualityProcessController : ControllerBase
    {
        private readonly IReviewerQualityProcessRepository _reviewerQualityProcessRepository;

        public ReviewerQualityProcessController(IReviewerQualityProcessRepository reviewerQualityProcessRepository)
        {
            _reviewerQualityProcessRepository = reviewerQualityProcessRepository;
        }

        [HttpPost("add")]
        public async Task<IActionResult> AddReviewerQualityProcess([FromBody] ReviewerQualityProcess review)
        {
            if (review == null)
                return BadRequest("Review data is null.");

            try
            {
                var newId = await _reviewerQualityProcessRepository.AddReviewerQualityProcessAsync(review);

                if (newId > 0)
                    return Ok(new { Success = true, Message = "Inserted successfully", NewId = newId });
                else
                    return StatusCode(500, new { Success = false, Message = "Insertion failed" });
            }
            catch (Exception ex)
            {
                return StatusCode(500, new { Success = false, Message = "An error occurred", Details = ex.Message });
            }
        }
    }
}
