﻿using Microsoft.AspNetCore.Mvc;
using NT.AltText.Controllers;
using NT.AltText.Models;
using NT.AltText.Repository.Interfaces;

namespace NT.AltText.Controllers
{
    [Route("api/[controller]")]
    [ApiController]
    public class JobController : ControllerBase
    {
        private readonly IJobRepository _repository;

        public JobController(IJobRepository repository)
        {
            _repository = repository;
        }

        [HttpGet]
        public async Task<IActionResult> GetAll()
        {
            var jobs = await _repository.GetAllJobsAsync();
            return Ok(jobs);
        }

        [HttpGet("{id}")]
        public async Task<IActionResult> GetById(int id)
        {
            var job = await _repository.GetJobByIdAsync(id);
            if (job == null) return NotFound();
            return Ok(job);
        }

        [HttpPost]
        public async Task<IActionResult> Create(JobDetails job)
        {
            var created = await _repository.AddJobAsync(job);
            return Ok(created);
        }

        [HttpPut("{id}")]
        public async Task<IActionResult> Update(int id, JobDetails job)
        {
            var updated = await _repository.UpdateJobAsync(id, job);
            if (updated == null) return NotFound();
            return Ok(updated);
        }

        [HttpDelete("{id}")]
        public async Task<IActionResult> Delete(int id)
        {
            var deleted = await _repository.DeleteJobAsync(id);
            if (!deleted) return NotFound();
            return NoContent();
        }
    }
}
