﻿using Microsoft.AspNetCore.Mvc;
using NT.AltText.Controllers;
using NT.AltText.Models;
using NT.AltText.Repository.Interfaces;

namespace NT.AltText.Controllers
{
    [Route("api/[controller]")]
    [ApiController]
    public class AnalysisController : ControllerBase
    {
        private readonly IAnalysisRepository _repository;

        public AnalysisController(IAnalysisRepository repository)
        {
            _repository = repository;
        }



        [HttpPost]
        public async Task<IActionResult>  AddAnalysis(Analysis analysis)
        {
           var result= await _repository.AddAnalysis(analysis);
            return Ok(result);

        }
        
    }
}
