﻿using System.Data;
using Microsoft.Data.SqlClient;
using NT.AltText.Models;
using NT.AltText.Repository.Database;
using NT.AltText.Repository.Interfaces;
using NT.AltText.Repository.Models;

namespace NT.AltText.Repository
{
    public class ReviewerQualityProcessRepository : IReviewerQualityProcessRepository
    {
        private readonly string connectionString = AltTextDbConnection.GetConnection();

        public async Task<int> AddReviewerQualityProcessAsync(ReviewerQualityProcess review)
        {
            using var conn = new SqlConnection(connectionString);
            using var cmd = new SqlCommand(SpNames.AddReviewerQualityProcess, conn)
            {
                CommandType = CommandType.StoredProcedure
            };

            cmd.Parameters.AddWithValue("@JobId", (object?)review.JobId ?? DBNull.Value);
            cmd.Parameters.AddWithValue("@AtChapterNumber", review.AtChapterNumber);
            cmd.Parameters.AddWithValue("@AtChapterTitle", (object?)review.AtChapterTitle ?? DBNull.Value);
            cmd.Parameters.AddWithValue("@AtImageCount", (object?)review.AtImageCount ?? DBNull.Value);
            cmd.Parameters.AddWithValue("@AtPickupCount", (object?)review.AtPickupCount ?? DBNull.Value);
            cmd.Parameters.AddWithValue("@AtDecorItemCount", (object?)review.AtDecorItemCount ?? DBNull.Value);
            cmd.Parameters.AddWithValue("@AtFreshWriteUpCount", (object?)review.AtFreshWriteUpCount ?? DBNull.Value);
            cmd.Parameters.AddWithValue("@AtSimple", (object?)review.AtSimple ?? DBNull.Value);
            cmd.Parameters.AddWithValue("@AtModerate", (object?)review.AtModerate ?? DBNull.Value);
            cmd.Parameters.AddWithValue("@AtComplex", (object?)review.AtComplex ?? DBNull.Value);
            cmd.Parameters.AddWithValue("@AtEstimateValue", (object?)review.AtEstimateValue ?? DBNull.Value);
            cmd.Parameters.AddWithValue("@AtGrCount", (object?)review.AtGrCount ?? DBNull.Value);
            cmd.Parameters.AddWithValue("@AtEnFree", (object?)review.AtEnFree ?? DBNull.Value);
            cmd.Parameters.AddWithValue("@AtContextEn", (object?)review.AtContextEn ?? DBNull.Value);
            cmd.Parameters.AddWithValue("@AtConvexEn", (object?)review.AtConvexEn ?? DBNull.Value);
            cmd.Parameters.AddWithValue("@AtGuildeline", (object?)review.AtGuildeline ?? DBNull.Value);
            cmd.Parameters.AddWithValue("@AtGrammarEn", (object?)review.AtGrammarEn ?? DBNull.Value);
            cmd.Parameters.AddWithValue("@Status", (object?)review.Status ?? DBNull.Value);

            var outputIdParam = new SqlParameter("@NewId", SqlDbType.Int)
            {
                Direction = ParameterDirection.Output
            };
            cmd.Parameters.Add(outputIdParam);

            await conn.OpenAsync();
            await cmd.ExecuteNonQueryAsync();

            return outputIdParam.Value == DBNull.Value ? 0 : (int)outputIdParam.Value;
        }
    }
}
