﻿using NT.AltText.Models;
using Microsoft.Extensions.Configuration;

namespace NT.AltText.Repository.Models
{
    public static class AltTextDbConnection 
    {
        public static string GetConnection()
        {
            var config = new ConfigurationBuilder()
                .SetBasePath(AppDomain.CurrentDomain.BaseDirectory)
                .AddJsonFile("appsettings.json", optional: false, reloadOnChange: true)
                .AddEnvironmentVariables()
                .Build();

            string conn = config.GetConnectionString("AltTextDatabase");
            return conn;
        }
    }
}