﻿using System.Data;
using Microsoft.Data.SqlClient;
using NT.AltText.Models;
using NT.AltText.Repository.Database;
using NT.AltText.Repository.Interfaces;
using NT.AltText.Repository.Models;

namespace NT.AltText.Repository
{
    public class CatsheetImageProcessingDetailsRepository : ICatsheetImageProcessingDetailsRepository
    {
        private readonly string connectionString = AltTextDbConnection.GetConnection();

        public async Task<int> AddCatsheetImageProcessingDetails(CatsheetImageProcessingDetails catsheetdetails)
        {
            using var conn = new SqlConnection(connectionString);
            using var cmd = new SqlCommand(SpNames.AddCatsheetImageProcessingDetails, conn)
            {
                CommandType = CommandType.StoredProcedure
            };

            cmd.Parameters.AddWithValue("@CatsheetImageProcessingId", (object?)catsheetdetails.CatsheetImageProcessingId ?? DBNull.Value);
            cmd.Parameters.AddWithValue("@JobId", (object?)catsheetdetails.JobId ?? DBNull.Value);
            cmd.Parameters.AddWithValue("@ChapterNumber", (object?)catsheetdetails.ChapterNumber ?? DBNull.Value);
            cmd.Parameters.AddWithValue("@ChapterTitle", (object?)catsheetdetails.ChapterTitle ?? DBNull.Value);
            cmd.Parameters.AddWithValue("@ImageCount", (object?)catsheetdetails.ImageCount ?? DBNull.Value);
            cmd.Parameters.AddWithValue("@PickupCount", (object?)catsheetdetails.PickupCount ?? DBNull.Value);
            cmd.Parameters.AddWithValue("@DecorativeItemCount", (object?)catsheetdetails.DecorativeItemCount ?? DBNull.Value);
            cmd.Parameters.AddWithValue("@FreshWriteUp", (object?)catsheetdetails.FreshWriteUp ?? DBNull.Value);
            cmd.Parameters.AddWithValue("@Simple", (object?)catsheetdetails.Simple ?? DBNull.Value);
            cmd.Parameters.AddWithValue("@Moderate", (object?)catsheetdetails.Moderate ?? DBNull.Value);
            cmd.Parameters.AddWithValue("@Complex", (object?)catsheetdetails.Complex ?? DBNull.Value);
            cmd.Parameters.AddWithValue("@EstimateValue", (object?)catsheetdetails.EstimateValue ?? DBNull.Value);

            var outputIdParam = new SqlParameter("@NewId", SqlDbType.Int)
            {
                Direction = ParameterDirection.Output
            };
            cmd.Parameters.Add(outputIdParam);

            await conn.OpenAsync();
            await cmd.ExecuteNonQueryAsync();

            return outputIdParam.Value == DBNull.Value ? 0 : (int)outputIdParam.Value;
        }
    }
}
