using NT.AltText.Repository;
using NT.AltText.Repository.Interfaces;

var builder = WebApplication.CreateBuilder(args);

// Add services to the container.

builder.Services.AddControllers();
// Learn more about configuring Swagger/OpenAPI at https://aka.ms/aspnetcore/swashbuckle
builder.Services.AddEndpointsApiExplorer();
builder.Services.AddSwaggerGen();

//dependency injection.
builder.Services.AddScoped<IJobRepository, JobRepository>();
builder.Services.AddScoped<IUserJobRepository, JobAssignedRepository>();
builder.Services.AddScoped<IAnalysisRepository, AnalysisRepository>();
builder.Services.AddScoped<ICatsheetImageProcessingRepository, CatsheetImageProcessingRepository>();
builder.Services.AddScoped<ICatsheetImageProcessingDetailsRepository, CatsheetImageProcessingDetailsRepository>();
builder.Services.AddScoped<IReviewerQualityProcessRepository, ReviewerQualityProcessRepository>();






var app = builder.Build();

// Configure the HTTP request pipeline.
if (app.Environment.IsDevelopment())
{
    app.UseSwagger();
    app.UseSwaggerUI();
}

app.UseHttpsRedirection();

app.UseAuthorization();

app.MapControllers();

app.Run();
