﻿using Microsoft.AspNetCore.Mvc;
using NT.AltText.Models;
using NT.AltText.Repository.Interfaces;

namespace NT.AltText.API.Controllers
{
    [ApiController]
    [Route("api/[controller]")]
    public class CatsheetImageProcessingDetailsController : ControllerBase
    {
        private readonly ICatsheetImageProcessingDetailsRepository _repository;

        public CatsheetImageProcessingDetailsController(ICatsheetImageProcessingDetailsRepository repository)
        {
            _repository = repository;
        }

        [HttpPost("add")]
        public async Task<IActionResult> Add([FromBody] CatsheetImageProcessingDetails catsheetdetails)
        {
            var id = await _repository.AddCatsheetImageProcessingDetails(catsheetdetails);
            return Ok(new { InsertedId = id });
        }
    }
}
