﻿using Microsoft.AspNetCore.Mvc;
using NT.AltText.Models;
using NT.AltText.Repository.Interfaces;

namespace NT.AltText.API.Controllers
{
    [ApiController]
    [Route("api/[controller]")]
    public class CatsheetImageProcessingController : ControllerBase
    {
        private readonly ICatsheetImageProcessingRepository _repository;

        public CatsheetImageProcessingController(ICatsheetImageProcessingRepository repository)
        {
            _repository = repository;
        }

        [HttpPost]
        public async Task<IActionResult> Add([FromBody] CatsheetImageProcessing catsheet)
        {
            if (catsheet == null)
                return BadRequest("Invalid data.");

            var newId = await _repository.AddCatsheetImageProcessing(catsheet);

            if (newId == 0)
                return StatusCode(500, "Insert failed.");

            return Ok(new { Id = newId });
        }
    }
}
